' L'interface d'vnements du moteur.
Public Interface IEngineEvents
    Sub AboutToBlow(ByVal msh As String)
    Sub Exploded(ByVal msg As String)
End Interface

Public Class Car
    ' Le tableau des collecteurs connects.
    Private itfConnections As ArrayList = New ArrayList()

    ' Attacher ou dconnecter de la source des vnements.
    Public Sub Advise(ByVal itfClientImpl As IEngineEvents)
        itfConnections.Add(itfClientImpl)
    End Sub


    ' Note : A tous les programmeurs COM qui lisent ceci,
    ' sachez que IConnectionPoint::Unadvise()
    ' rcupre un enregistrement pralablement assign par ICP:Advise().
    ' Ceci est d au fait que VOUS crivez le code pour appeler
    ' le collecteur du ct client et que devez rduire le tableau
    ' de pointeur IUnknown* quand un client se dconnecte.
    ' Comme le tableau ArrayList se rduit dynamiquement, vous n'avez 
    ' qu' passer le collecteur qui doit tre supprim.
    Public Sub Unadvise(ByVal itfClientImpl As IEngineEvents)
        itfConnections.Remove(itfClientImpl)
    End Sub

    Public Class Radio
        Public Sub TurnOn(ByVal state As Boolean)
            If (state) Then
                Console.WriteLine("Diffusion en cours...")
            Else
                Console.WriteLine("Autoradio au repos...")
            End If
        End Sub
    End Class

    ' Donnes d'tat inerne.
    Private currSpeed As Integer
    Private maxSpeed As Integer
    Private petName As String

    ' La voiture est-elle en tat de marche ou hors-service ?
    Private dead As Boolean

    ' Une voiture possde un auto-radio.
    Private theMusicBox As Radio

    ' Constructeurs.
    Public Sub New()
        maxSpeed = 100
        dead = False
        theMusicBox = New Radio()
    End Sub
    Public Sub New(ByVal name As String, ByVal max As Integer, ByVal curr As Integer)

        currSpeed = curr
        maxSpeed = max
        petName = name
        dead = False
        theMusicBox = New Radio()
    End Sub

    Public Sub CrankTunes(ByVal state As Boolean)
        theMusicBox.TurnOn(state)
    End Sub

    Public Sub SpeedUp(ByVal delta As Integer)
        ' Si la voiture est hors-service, envoyer un vnement.
        If (dead) Then
            Dim e As IEngineEvents
            Dim i As Integer
            For i = 0 To itfConnections.Count - 1
                e = CType(itfConnections(i), IEngineEvents)

                e.Exploded("Dsol, cette voiture est hors-service...")
            Next
        Else
            currSpeed += delta

            ' Presque hors-service ?
            If (10 = maxSpeed - currSpeed) Then
                Dim e As IEngineEvents
                Dim i As Integer
                For i = 0 To itfConnections.Count - 1
                    e = CType(itfConnections(i), IEngineEvents)
                    e.AboutToBlow("Attention !  Ca va exploser !")
                Next
            End If

            ' Toujours OK !
            If (currSpeed >= maxSpeed) Then
                dead = True
            Else
                Console.WriteLine("->Vitesse actuelle = {0}", currSpeed)
            End If
        End If
    End Sub
End Class